﻿Clear-Host;

$d = Get-Date;
$bd = New-Object Datetime(1970, 1,1); # Android Base date
$ts = New-Object timespan(365, 0, 0, 0); 

$cd = $d.AddMonths(-12); # cutoff date 12 months ago

$ts = ($cd - $bd); # difference between android base date and cut off date

$cutOff = $ts.TotalMilliseconds; # number of milliseconds since android base date

#the export file from sms backup
[xml]$cn = Get-Content 'F:\01_Pauls\sms\sms-20190801115453.xml';

# the full path were the copy of the export file will live
$newPath = 'F:\01_Pauls\sms\sms-processed.xml';

#array of lines of xml
$lines= @();

# loop through the xml document, if sms check how old it is, if it's newer than the cutoff date add it to the array
# just include mms
foreach ($mess in $cn.ChildNodes[2].ChildNodes) {
    
    If ($mess.Name -eq "sms") {
        $smsdt = [Convert]::ToUInt64($mess.date_sent);
        If ($smsdt -ge $cutOff) {
             $lines += $mess.OuterXml; 
        }
    } else { #mms
        $lines += $mess.OuterXml;
    }
};

# add the original headers back in
$cn.ChildNodes[0].OuterXml | Out-File -FilePath $newPath -Encoding utf8 ;
$cn.ChildNodes[1].OuterXml | Out-File -FilePath $newPath -Append -Encoding utf8 ;

#create a new header now we know how many lines we have included
"<smses count=`"$($lines.Length)`" backup_set=`"$((New-Guid).ToString())`" backup_date=`"$(($d-$bd).TotalMilliseconds.ToString())`">" | Out-File -FilePath $newPath -Append -Encoding utf8 ;

#output the array to the file
foreach($line in $lines) {
    $line | Out-File -FilePath $newPath -Append -Encoding utf8 ;
}

# terminate the xml document
"</smses>" | Out-File -FilePath $newPath -Append -Encoding utf8 ;